# HighNoon release 1 by David Bowland
# ./addons/eventscripts/highnoon/highnoon.py

# >>> To configure this addon please see highnoon.cfg (created whent he addon is first loaded) <<<

"""
Changes the brightness of each map based on the time the map started. Can simulate multiple 24-hours cycles in a single day. Requires only ES 2.0+
"""


import cfglib
import es
import gamethread
import time

import psyco
psyco.full()


info = es.AddonInfo()
info.name     = 'HighNoon'
info.version  = '1'
info.basename = 'highnoon'
info.url      = 'http://addons.eventscripts.com/addons/view/' + info.basename
info.author   = 'SuperDave'


###


config = cfglib.AddonCFG(es.getAddonPath(info.basename) + '/' + info.basename + '.cfg')

config.text(info.name + ' release %s options' % info.version)
config.text('./addons/eventscripts/%(basename)s/%(basename)s.cfg' % {'basename':info.basename})
config.text(info.url)
config.text('')
config.text('Load this addon with: es_load ' + info.basename)
config.text('\n')
config.text('To configure language settings for %s please see %s_languages.ini' % (info.name, info.basename))
config.text('\n')

config.text('***** General options *****')
cvar_midnight       = config.cvar('highnoon_midnight',       '00:00', 'Server time that represents midnight of the first cycle in the format "H:M" where H is 0-23 and M is 0-59')
cvar_cycles         = config.cvar('highnoon_cycles',         8,       'Number of day cycles in a 24 hour period')
cvar_brightness_min = config.cvar('highnoon_brightness_min', 1,       'Minimum brightness from 0 to 25 inclusive')
cvar_brightness_max = config.cvar('highnoon_brightness_max', 25,      'Maximum brightness from 0 to 25 inclusive')
config.text('\n')

config.text('***** Skybox options *****')
config.text('')
config.text('Use the following server command to add skyboxes to HighNoon:')
config.text('')
config.text('highnoon_add <skybox>')
config.text('\n')

config.text('Place your highnoon_add commands below from darkest to lightest:')
config.command('highnoon_add')
config.text('\n')

config.text('Uncomment the following default options if you wish to use them:')
config.text('')
config.text('highnoon_add sky_borealis01')
config.text('highnoon_add sky_day01_09')
config.text('highnoon_add sky_day02_09')
config.text('highnoon_add sky_day03_06')
config.text('highnoon_add hav')
config.text('highnoon_add sky_day03_03')
config.text('highnoon_add jungle')
config.text('highnoon_add de_cobble')
config.text('highnoon_add sky_day01_08')
config.text('highnoon_add sky_day01_07')
config.text('highnoon_add sky_day01_06')
config.text('highnoon_add sky_day03_04')
config.text('highnoon_add sky_day03_02')
config.text('highnoon_add sky_day03_01')
config.text('highnoon_add sky_day03_05')
config.text('highnoon_add sky_day01_01')
config.text('highnoon_add de_piranesi')
config.text('highnoon_add italy')
config.text('highnoon_add sky_day02_07')
config.text('highnoon_add sky_day02_06')
config.text('highnoon_add office')
config.text('highnoon_add sky_day01_05')
config.text('highnoon_add sky_day02_05')
config.text('highnoon_add sky_day01_04')
config.text('highnoon_add sky_day02_04')
config.text('highnoon_add sky_day02_03')
config.text('highnoon_add sky_day02_02')
config.text('highnoon_add sky_day02_01')
config.text('highnoon_add train')
config.text('highnoon_add tides')
config.text('highnoon_add cx')
config.text('highnoon_add sky_dust')
config.text('\n')

config.text('Skyboxes can be removed with the following server command:')
config.text('')
config.text('highnoon_remove <skybox>')
config.text('')
config.text('Due to the fact skyboxes can be added and removed above, this command will not be used by most users.')
config.text('\n')

config.text('***** Documentation *****')
config.text('')
config.text('You can set the percent of the cycle that has passed for the next map by setting the highnoon_override cvar.')
config.text('Said variable resets itself to -1 (no change) every map.')

config.write()


cvar_override = es.ServerVar('highnoon_override', -1, 'Overrides the percent of the cycle that has passed for the next map')


###


class HighNoonManager(object):
   sv_skyname = es.ServerVar('sv_skyname')
   # index = 0

   def __init__(self):
      self.skyboxes = []

   def setBrightness(self):
      hn.cancelDelayed()

      cycle = (24 * 60) / cvar_cycles

      cyclestart = map(int, str(cvar_midnight).split(':'))
      midnight   = cyclestart[0] + cyclestart[1] * 60

      override = int(cvar_override)
      if 0 <= override <= 100:
         now = cycle * override / 100

      else:
         localtime = time.localtime()
         now       = abs(localtime.tm_hour * 60 + localtime.tm_min - midnight) % cycle
      cvar_override.set(-1)

      brightness_range = range(cvar_brightness_min, cvar_brightness_max) + range(cvar_brightness_max, cvar_brightness_min, -1)
      lightstyle       = chr(97 + brightness_range[int(now / (float(cycle) / len(brightness_range)))])

      skybox_range = self.skyboxes + list(reversed(self.skyboxes))[1:~0]
      if skybox_range:
         self.sv_skyname.set(skybox_range[int(now / (float(cycle) / len(skybox_range)))])

      """
      self.sv_skyname.set(self.skyboxes[self.index])
      self.index += 1
      es.msg('testing %s' % self.sv_skyname)
      """

      gamethread.delayedname(0.1, 'highnoon', es.lightstyle, (0, lightstyle))

   def addSkyBox(self, name):
      self.skyboxes.append(name)

   def removeSkyBox(self, name):
      if name in self.skyboxes:
         self.skyboxes.remove(name)

   @staticmethod
   def cancelDelayed():
      gamethread.cancelDelayed('highnoon')

hn = HighNoonManager()


def addskybox_cmd():
   """
   highnoon_add <skybox>
   """
   if es.getargc() == 2:
      hn.addSkyBox(es.getargv(1))

   else:
      es.dbgmsg(0, 'Syntax: highnoon_add <skybox>')

if not es.exists('command', 'highnoon_add'):
   es.regcmd('highnoon_add', 'highnoon/addskybox_cmd', 'highnoon_add <skybox>\nServer command to add skyboxes to HighNoon')


def removeskybox_cmd():
   """
   highnoon_remove <skybox>
   """
   if es.getargc() == 2:
      hn.removeSkyBox(es.getargv(1))

   else:
      es.dbgmsg(0, 'Syntax: highnoon_remove <skybox>')

if not es.exists('command', 'highnoon_remove'):
   es.regcmd('highnoon_remove', 'highnoon/removeskybox_cmd', 'highnoon_remove <skybox>\nServer command to remove skyboxes from HighNoon')


###


def load():
   config.execute()


def es_map_start(event_var):
   hn.setBrightness()


def unload():
   hn.cancelDelayed()

   for cvar in config.getCvars():
      es.ServerVar(cvar).set(0)